<?php
/*--------------------------------------------------------------------------------------------------
    PropertyQuantityReadServiceInterface.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Services;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\AbstractPropertyQuantity;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\CombinationQuantity;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\PropertyTotalQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use ProductDataInterface;

interface PropertyQuantityReadServiceInterface
{
    
    /**
     * @param SellingUnitId        $id
     * @param ProductDataInterface $product
     *
     * @return AbstractPropertyQuantity
     */
    public function getQuantityBy(SellingUnitId $id, ProductDataInterface $product) : ?AbstractPropertyQuantity;
    
}